/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationResult;

/**
 * Utility class used to create message arguments for validation results.
 */
public final class ValidationMessageHelper {

    /**
     * Create an object array of message arguments.
     * 
     * @param results
     *            validation results
     * @return message object array
     */
    public static Object[] getMessageArgs(
            Map<ValidationResult, ValidateContext> results) {
        List<Object> args = new ArrayList<Object>();
        for (ValidationResult vr : results.keySet()) {
            if (!vr.succeeded()) {
                args.add(vr.getMsgArgs());
            }
        }
        return args.toArray();
    }

    /**
     * Get only the failed validation results.
     * @param results map of all validation results
     * @return map containing only failed validation results
     */
    public static Map<ValidationResult, ValidateContext> getFailed(
            Map<ValidationResult, ValidateContext> results) {
        Map<ValidationResult, ValidateContext> failed =
                new HashMap<ValidationResult, ValidateContext>();
        for (Entry<ValidationResult, ValidateContext> entry : results.entrySet()) {
            if (!entry.getKey().succeeded()) {
                failed.put(entry.getKey(), entry.getValue());
            }
        }
        return failed;
    }

    /**
     * Test if all validation results have succeeded.
     * 
     * @param results
     *            map of validation results
     * @return <code>true</code> if all validation results have succeeded.
     */
    public static boolean succeeded(
            Map<ValidationResult, ValidateContext> results) {
        for (ValidationResult result : results.keySet()) {
            if (!result.succeeded()) {
                return false;
            }
        }
        return true;
    }
}
