/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.List;

/**
 * The action executor. Implementors of this interface might choose to execute
 * actions on a dedicated thread.
 */
public interface ActionExecutor {

    /**
     * Executes the specified action
     * 
     * @param action the action to execute.
     */
    public void execute(G9Action<?> action);

    /**
     * Shuts down the executor.
     */
    public void shutDown();

    /**
     * Shuts down the executor
     * 
     * @return a list of runnables that was not executed before shut down.
     */
    public List<Runnable> shutdownNow();
}
