/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import no.g9.support.ActionType;
import no.g9.support.action.ActionTarget;

/**
 * This class represents an action definition for a dialog method.
 * Each method may have a number actions in the dialog model.
 */
public class ActionInfo {
	
	private ActionType actionType;
	
	private ActionTarget actionTarget;
	
	private String description;

	/**
	 * Create a new ActionInfo object with the given parameters.
	 * 
	 * @param actionType the action type
	 * @param actionTarget the target of the action
	 * @param description the description of the action definition in the dialog model
	 */
	public ActionInfo(ActionType actionType, ActionTarget actionTarget, String description) {
		this.actionType = actionType;
		this.actionTarget = actionTarget;
		this.description = description;
	}

	/**
	 * @return the actionType
	 */
	public ActionType getActionType() {
		return actionType;
	}

	/**
	 * @param actionType the actionType to set
	 */
	public void setActionType(ActionType actionType) {
		this.actionType = actionType;
	}

	/**
	 * @return the actionTarget
	 */
	public ActionTarget getActionTarget() {
		return actionTarget;
	}

	/**
	 * @param actionTarget the actionTarget to set
	 */
	public void setActionTarget(ActionTarget actionTarget) {
		this.actionTarget = actionTarget;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

}
