/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;

/** The canceling state, cancels the action and invokes the cancelled hook.
 * @param <V> type */
class Cancelling<V> implements Callable<Void> {

    /**
	 *
	 */
	private final G9Action<V> ga;

	/**
	 * @param g9Action action
	 */
	Cancelling(G9Action<V> g9Action) {
		ga = g9Action;
	}

    /**
     * The cancelled hook, invoked if the action is cancelled before or during
     * the execution of the action. This hook is invoked on a dedicated worker thread by
     * default. Use the annotation {@link ThreadInfo} to control which thread
     * this method is invoked on.
     *
     * @return Void - e.g. null
     * @exception Exception re-throws exception from hook method
     */
    Void cancelled() throws Exception {
        if (ga.shouldInvokeHook()) {
            String methodName = "cancelled";
            ThreadType threadType = ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> invocation = new HookMethod<Void>(methodName) {

                @Override
                public Void call() {
                    for (ActionHook<?> hook : ga.getActionHookList().getHooks()) {
                        hook.cancelled();
                    }
                    return null;
                }
            };
            ga.getHookInvoker().execute(ga.getApplicationController(), threadType, invocation);
        }
        return null;
    }

	@Override
    public Void call() throws Exception {
	    cancelled();
	    G9Action.getLog().info(ga + " cancelled");
	    return null;
    }
}