/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

/**
 * The checkable interface. When an action reaches the checked state, 
 * the checked method is invoked.
 * @version 1.0
 */
public interface Checkable {
    
	/**
	 * Hook method invoked when an action is finished checking the dialog.
	 * @param checkOK the result of the check. 
	 * @return the boolean determening if the action should continue.
	 */
    public abstract Boolean checked(Boolean checkOK);

}