/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

/**
 * The hook adapter suitable for hooking on to displayable actions (e.g. find,
 * save).
 * 
 * @param <T> The action target class type.
 */
public abstract class DisplayableHookAdapter<T> extends
        ObtainableHookAdapter<T> implements Displayable {

    @Override
    public void cleared() {
        // Empty;
    }
    
    
    @Override
    public void displayed() {
        // Empty
    }

}