/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;


import no.g9.client.core.controller.DialogConstant;

import org.springframework.beans.factory.annotation.Required;

/**
 * Hook configurator
 *
 */
public class HookConfigurator {


    private DialogInteraction hook;
    private DialogConstant caller = null;
    private DialogConstant callee = null;

    /**
     * set the caller
     *
     * @param caller
     *            of the configurator
     */
    public void setCaller(DialogConstant caller) {
        this.caller = caller;
    }

    /**
     * Return the caller
     *
     * @return the caller
     */
    public DialogConstant getCaller() {
        return caller;
    }

    /**
     * @param callee
     *            of the configurator
     */
    public void setCallee(DialogConstant callee) {
        this.callee = callee;
    }

    /**
     * returns the calle
     *
     * @return the callee
     */
    public DialogConstant getCallee() {
        return callee;
    }

    /**
     * sets the hook
     *
     * @param hook
     *            of the configurator
     */
    @Required
    public void setHook(DialogInteraction hook) {
        this.hook = hook;
    }

    /**
     * Return the hook
     *
     * @return the hook
     */
    public DialogInteraction getHook() {
        return hook;
    }

    @Override
    public String toString() {
        return "HookConfigurator [hook=" + hook + ", caller=" + caller
                + ", callee=" + callee + "]";
    }

}
