/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

/**
 * The obtainable interface defines the obtained hook. Action hooks that are
 * registered on actions that perform obtain, might implement this interface. If
 * so, the obtained method will be invoked after the (action's) obtain is done.
 */
public interface Obtainable {

    /**
     * The obtained hook, invoked after the checked hook and before the
     * performed hook.
     * <p>
     * If applicable, this hook is invoked on a dedicated worker thread by
     * default. Use the annotation {@link ThreadInfo} to control which thread
     * this method is invoked on.
     *
     * @param objectSelection the obtained object selection
     * @return the object selection that will be used when processing the action
     */
    @ThreadInfo(ThreadType.WORKER)
    public ObjectSelection obtained(ObjectSelection objectSelection);

    /**
     * The client context hook, invoked after the obtained hook and before the
     * performed hook.
     * <p>
     * If applicable, this hook is invoked on a dedicated worker by default. Use
     * the annotation {@link ThreadInfo} to control which thread this method is
     * invoked on.
     *
     * @param clientContext the application's client context
     * @return the client context that will be used for the service call
     */
    @ThreadInfo(ThreadType.WORKER)
    public ClientContext contextHook(ClientContext clientContext);

}