/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;


/**
 * @param <T> the target type of the hook 
 */
public abstract class ObtainableHookAdapter<T> extends CheckableHookAdapter<T>
        implements Obtainable {

    /**
     * Default implementation of the obtained method. Returns the
     * objectSelection. 
     */
    @Override
    public ObjectSelection obtained(ObjectSelection objectSelection) {
        return objectSelection;
    }

    @Override
    public ClientContext contextHook(ClientContext clientContext) {
        return clientContext;
    }
    
    

}