/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation denoting the thread a method is to be invoked on, either
 * a worker thread or a gui thread (where applicable).
 * <p>Application developers should annotate hook methods with this annotation, thus
 * controlling which thread the hook-method invocation is done on. The
 * value should be either <strong>"GUI"</strong> or <strong>"Worker"</strong>.
 * 
 * @see ThreadType for more information about thread types
 * 
 * 
 *
 */
@Inherited
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ThreadInfo {
    /** The supplied value */
    ThreadType value();
}
