/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.communication;


/**
 * Implementor is able to receive messages.
 *
 */
public interface MessageReceiver {
	/**
	 * Receive a message.
	 * 
	 * @param decodedMessage The message
	 * @param messageContext The context for the given decodedMessage 
	 */
	void receive(SystemMessage decodedMessage, SystemMessageContext messageContext);

}
