/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

/**
 * All dialog object types which can be generated from a dialog model.
 */
@SuppressWarnings("javadoc")
public enum DialogObjectType {

	/** The non-data object types */
	Button(DialogObjectTypeClass.NonData),
	Label(DialogObjectTypeClass.NonData),
	ImageBox(DialogObjectTypeClass.NonData),
	MenuItem(DialogObjectTypeClass.NonData),
	Separator(DialogObjectTypeClass.NonData),
	Spacer(DialogObjectTypeClass.NonData),
	Viewport(DialogObjectTypeClass.NonData),
	Component(DialogObjectTypeClass.NonData),
	Text(DialogObjectTypeClass.NonData),
	ScrollBar(DialogObjectTypeClass.NonData),

	/** The data object types */
	CheckButton(DialogObjectTypeClass.Data),
	ComboBox(DialogObjectTypeClass.Data),
	ListBox(DialogObjectTypeClass.Data),
	RadioGroup(DialogObjectTypeClass.Data),
	Scale(DialogObjectTypeClass.Data),
	Stepper(DialogObjectTypeClass.Data),
	TextField(DialogObjectTypeClass.Data),
	DataComponent(DialogObjectTypeClass.Data),

	/** The container types */
	WindowBlock(DialogObjectTypeClass.Container),
	SimpleBlock(DialogObjectTypeClass.Container),
	TableBlock(DialogObjectTypeClass.Container),
	MenuBar(DialogObjectTypeClass.Container),
	Menu(DialogObjectTypeClass.Container),
	ToolBar(DialogObjectTypeClass.Container),
	Notebook(DialogObjectTypeClass.Container),
	@Deprecated
	ListBlock(DialogObjectTypeClass.Container),
	TreeView(DialogObjectTypeClass.Container),
	TreeNode(DialogObjectTypeClass.Container);

	private enum DialogObjectTypeClass {
		Data,
		NonData,
		Container;
	}

	private DialogObjectTypeClass dialogObjectTypeClass;

	private DialogObjectType(DialogObjectTypeClass clazz) {
		this.dialogObjectTypeClass = clazz;
	}

	public boolean isNonData() {
		return dialogObjectTypeClass == DialogObjectTypeClass.NonData;
	}

	public boolean isData() {
		return dialogObjectTypeClass == DialogObjectTypeClass.Data;
	}

	public boolean isContainer() {
		return dialogObjectTypeClass == DialogObjectTypeClass.Container;
	}

}
