/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

import java.util.List;

import no.g9.client.core.validator.ValidationResult;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.support.convert.ConvertException;

/**
 * Exception thrown when something has failed during a display.
 */
public class DisplayException extends G9ClientFrameworkException {

    private final List<ValidationResult> validationResult;

    private final List<ConvertException> convertException;

    /**
     * Constructs a new display exception.
     * 
     * @param validationResult the list of validation result that caused this
     *            exception
     * @param convertException the list of convert exceptions that caused this
     *            exception.
     */
    public DisplayException(List<ValidationResult> validationResult,
            List<ConvertException> convertException) {
        super();
        this.validationResult = validationResult;
        this.convertException = convertException;
    }

    /**
     * Get the list of validation result that caused this exception.
     * 
     * @return the validationResult the list of failed validation results.
     */
    final List<ValidationResult> getValidationResult() {
        return validationResult;
    }

    /**
     * Get the list of converter exceptions that caused this exception.
     * 
     * @return the convertException the list of failed converters.
     */
    final List<ConvertException> getConvertException() {
        return convertException;
    }
}
