/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

import no.g9.exception.G9ClientFrameworkException;

/**
 * Exception thrown when trying to open a new dialog and number of already open instances equals the threshold defined 
 * in {@link DialogConstant#getMaximumNumberOfInstances()}.
 *
 */
public class InstanceNumberOutOfBoundsException extends G9ClientFrameworkException {

 
    /**
     * Instantiates a new exception with the given message.
     *
     * @param message the message
     */
    public InstanceNumberOutOfBoundsException(String message) {
        super(message);
    }

  

}
