/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

/**
 * Enumerates the possible states of an object selection node.
 */
public enum RoleState {
    
    /**
     * The initial state of the node. No data is displayed, and the user
     * has not made any changes to the dialog. Invoking clear on a node
     * will put it in this state.
     * 
     */
    CLEARED,
    
    /**
     * The state that occurs when an initially CLEARED node has been altered
     * by the user.
     */
    EDITED,
    
    /**
     * The state that occurs when an object has been displayed, but not
     * altered by the user.
     */
    CLEAN,
    
    /**
     * The state that occurs when an CLEAN node was altered by the
     * user.
     * 
     */
    DIRTY;
    
}
