/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.converter;

import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.support.convert.ConvertContext;

/**
 * Contains information about a field conversion context
 */
public class FieldConvertContext extends ConvertContext {

    private final DialogController dialogController;
    private final DialogObjectConstant dialogObjectConstant;

    /**
     * Constructs a new ValidationContext
     * @param dCtrl The DialogController of the context
     * @param dObjectConstant The DialogObjectConstant of the context
     */
    public FieldConvertContext(final DialogController dCtrl, final DialogObjectConstant dObjectConstant) {
        dialogController = dCtrl;
        dialogObjectConstant = dObjectConstant;
    }

    /**
     * @return the dialogController of the xontext
     */
    public DialogController getDialogController() {
        return dialogController;
    }

    /**
     * @return the dialogObjectConstant of the xontext
     */
    public DialogObjectConstant getDialogObjectConstant() {
        return dialogObjectConstant;
    }

    @Override
    public String toString() {
        return "FieldConvertContext [dialogController=" + dialogController + ", dialogObjectConstant=" + dialogObjectConstant
                + "]";
    }


}
