/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.converter;

import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;

/**
 * No operation converter. Returns the input value on all calls to toModel and
 * fromModel.
 *
 * Example of usage:
 *  &lt;bean id="nullConverter"
 *     class="no.g9.client.core.converter.NopConverter" /&gt;
 *
 * This bean is not configurable.
 *
 */
public class NopConverter implements AttributeConverter<Object, Object> {

    @Override
    public Class<Object> getModelType() {
        return Object.class;
    }

    @Override
    public Class<Object> getTargetType() {
        return Object.class;
    }

    @Override
    public Object toModel(Object value, ConvertContext context) {
        return value;
    }

    @Override
    public Object fromModel(Object value, ConvertContext context) {
        return value;
    }

}
