/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.message;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;
import no.g9.message.Message;

/**
 * A message callback that offers a blocking method to retrieve the message only
 * after the displaying thread has set the reply.
 */
@BeanID("messageCallback")
@G9PropertyName("MessageCallback")
public interface BlockingMessageCallback extends MessageCallback {
    /**
     * Get the message that is set by the {@link MessageCallback#reply(Message)}
     * method. Blocks until there is a message reply.
     * 
     * @return the callback's reply message.
     */
    Message getMessage();

}
