/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.message;

/**
 * Various targets might warrant different thread policy when interacting
 * messages. 
 */
public enum InteractionThreadPolicy {

    /** 
     * Message interaction is asynchronous and must either be done from gui 
     * thread, or supplied with own message callback.
     */
    ASYNC_GUI_POLICY("Message interaction is asynchronous and must either be done from gui thread, or supplied with own message callback"),

    /**
     * Message interaction is asynchronous and must either be done from worker 
     * thread, or supplied with own message callback.
     */
    ASYNC_WORKER_POLICY("Message interaction is asynchronous and must either be done from worker thread, or supplied with own message callback."),

    /**
     * Message interaction can be done from any thread, no need for message 
     * callback.
     */
    DEFAULT_POLICY("Message interaction can be done from any thread, no need for message callback.");
    
    private final String policyDescription;
    
    private InteractionThreadPolicy(String policyDescription) {
        this.policyDescription = policyDescription;
    }
    
    /**
     * Get the description of this thread interaction policy.
     * @return a detailed text describing the thread policy.
     */
    public String getPolicyDescription() {
        return policyDescription;
    }
}

