/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.message;

import no.g9.message.Message;


/**
 * Message callback, called from the asynchronous message handler after the user
 * has given a reply.
 */
public interface MessageCallback {

    /**
     * Reply callback with a given message. The reply of the message should
     * be set before calling this method.
     *
     * @param msg the message with a reply.
     */
    void reply(Message msg);

    /**
     * Get the thread policy that is enforced by this message call back.
     * @return the interaction thread policy of this message call back
     */
    InteractionThreadPolicy getInteractionThreadPolicy();


}
