/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.util;

import java.util.List;

import no.g9.client.core.controller.DialogController;
import no.g9.os.OSRole;
import no.g9.os.RoleConstant;

/**
 * The Class RoleNameHelper is used for getting the 
 * 			Table name, Column name from the objectSelection values.
 */
public class RoleNameHelper {
	
	private DialogController dialogController;

	/**
	 * Instantiates a new role name helper.
	 *
	 * @param dialogController the dialog controller
	 */
	public RoleNameHelper(DialogController dialogController) {
		this.dialogController = dialogController;
	}

	/**
	 * Gets the table name.
	 *
	 * @param rootAttribute the root attribute
	 * @return the table name
	 */
	public String getTableName(String rootAttribute) {
		OSRole<?> osRole = getRole(rootAttribute);
		Class<?> domainClass = osRole.getDomainClass();
		String tableName = domainClass.getSimpleName();
		return tableName;
	}
	
	/**
	 * Gets the column name.
	 *
	 * @param rootAttribute the root attribute
	 * @param roleAttribute the role attribute
	 * @return the column name
	 */
	public Object[] getColumnName(String rootAttribute, String roleAttribute){
		OSRole<?> osRole = getRole(rootAttribute);
		OSRole<?> childOsRole =getRole(roleAttribute);		
		Object[] colAndDataType= null;
		
		String columnName = roleAttribute.substring(roleAttribute.indexOf(".")+1,roleAttribute.length());
		Object dataType=(osRole.equals(childOsRole))?osRole.getAttributeConstant(columnName).getAttributeType().getName() : "";
		String displayRule=(osRole.equals(childOsRole))?osRole.getAttributeConstant(columnName).getDisplayRule() : "";
		if (!osRole.equals(childOsRole)) {
			List<OSRole<?>> children = osRole.getChildren();
			String childClass = "";
			for (OSRole<?> child : children) {
				if (child.getRoleConstant().equals(
						childOsRole.getRoleConstant())) {
					childClass = child.getDomainClass().getSimpleName().toLowerCase()+ ".";
					dataType = child.getAttributeConstant(columnName)
							.getAttributeType().getName();
					displayRule = child.getAttributeConstant(columnName).getDisplayRule();
					columnName = childClass + columnName;
				}
			}
		}
		if(columnName.equals("")){
			throw new IllegalArgumentException("No such role attribute " + roleAttribute);
		}
		displayRule=displayRule.replaceAll("m", "M");
		colAndDataType= new Object[]{columnName,dataType,displayRule};
		return colAndDataType;
	}

	private OSRole<?> getRole(String rootAttribute) {
		String root = rootAttribute.substring(0, rootAttribute.indexOf("."));
		RoleConstant osConst = dialogController.getOSConst(root);		
		if (osConst == null) {
			throw new IllegalArgumentException("No such role.");
		}
		OSRole<?> osRole = dialogController.getOSRole(osConst);		
		return osRole;
	}

}
