/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

/**
 * Enumerates boolean dialog object properties.
 */
public enum BooleanProperty implements Property<Boolean> {
    
    /** The editable property, defaults to <code>Boolean.TRUE</code> */
    EDITABLE(Boolean.TRUE),
    
    /** The enabled property, defaults to <code>Boolean.TRUE</code> */
    ENABLED(Boolean.TRUE),
    
    /** The mandatory property, defaults to <code>Boolean.FALSE</code> */
    MANDATORY(Boolean.FALSE),
    
    /** The shown property, defaults to <code>Boolean.TRUE</code> */
    SHOWN(Boolean.TRUE),

    /** The expanded property, defaults to <code>Boolean.FALSE</code> */
    EXPANDED(Boolean.FALSE);

    /** The default value */
    private final Boolean defaultValue;
    
    /** Construct a new boolean property enum.
     * 
     * @param defaultValue the value of the default
     */
    private BooleanProperty(Boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Boolean getDefaultValue() {
        return defaultValue;
    }
}
