/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

/**
 * An interface used to represent a property. 
 * 
 * @param <T> The type of the property, e.g. String, Color, Boolean ...
 */
public interface Property<T> {

    /**
     * Get the default value of the property. <em>OBS:</em> this might not be
     * applicable to all types of properties. In cases where there is no
     * meaningful default value, this method should return <code>null</code>.
     * 
     * @return the default property value, or <code>null</code> if no default
     *         exist.
     */
    T getDefaultValue();
}
