/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

import no.esito.util.BeanID;

/**
 * Resource Store is used to keep resources that the controller want the view to
 * grab (and possibly display)
 */
@BeanID("resourceStore")
public interface ResourceStore {

    /**
     * Put a new resource in the store.
     * 
     * @param resource the resource
     */
    void putResource(Resource resource);

    /**
     * Get the resource.
     * 
     * @param id unique id of the resource
     * @return the resource
     */
    Resource getResource(String id);

    /**
     * Removes the resource.
     * 
     * @param id unique id of the resource
     * @return the removed resource
     */
    Resource removeResource(String id);

}