/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

import java.util.HashMap;
import java.util.Map;

import no.g9.client.core.controller.DialogObjectConstant;

/**
 * Represents a general string property for dialog objects.
 *
 */
public final class StringProperty implements Property<Object> {

    private static Map<DialogObjectConstant, Map<String, StringProperty>> props=null;

    private StringProperty() {
        // Private constructor.1
    }

    /**
     * Get the instance representing the specified property for on the specified
     * dialog object.
     * 
     * @param dialogObject the dialog object whose property to get or set
     * @param key the name of the property
     * @return the string property.
     */
    public static synchronized StringProperty getInstance(DialogObjectConstant dialogObject,
        String key) {
    	if(props==null){
    		props=new HashMap<DialogObjectConstant, Map<String, StringProperty>>();
    	}
        Map<String, StringProperty> map = props.get(dialogObject);
        if (map == null) {
            map = new HashMap<String, StringProperty>();
            props.put(dialogObject, map);
        }

        StringProperty stringProperty = map.get(key);
        if (stringProperty == null) {
            stringProperty = new StringProperty();
            map.put(key, stringProperty);
        }

        return stringProperty;
    }

    @Override
    public final String getDefaultValue() {
        return null;
    }

}
