/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.menu;

import java.io.Serializable;

import no.g9.client.core.view.ImageInfo;

/**
 * Common super class for menus and menu items.
 */
public abstract class MenuBase implements Serializable {

    private String id;

    private String dialogId;

    private String applicationId;

    private String title;

    private String mnemonic;

    private String accelerator;

    private String style;

    private ImageInfo image;

    private ImageInfo disabledImage;

    private Menu parent;

    /**
     * @param id the ID of the menu or menu item
     * @param dialogId the ID of the dialog which owns the menu or menu item
     * @param title the title of the menu or menu item
     * @param mnemonic the mnemonic for the menu or menu item
     * @param accelerator the accelerator for the menu or menu item
     * @param style the style from the dialog model
     * @param image the image from the dialog model
     * @param disabledImage the disabled image from the dialog model
     */
    protected MenuBase(String id, String dialogId, String title, String mnemonic, String accelerator, String style, ImageInfo image, ImageInfo disabledImage) {
        super();
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        if (dialogId == null) {
            throw new IllegalArgumentException("dialogId can not be null");
        }
        this.id = id;
        this.dialogId = dialogId;
        this.title = title;
        this.mnemonic = mnemonic;
        this.accelerator = accelerator;
        this.style = style;
        this.image = image;
        this.disabledImage = disabledImage;
        this.parent = null;
    }
    
    /**
     * @param id the ID of the menu or menu item
     * @param dialogId the ID of the dialog which owns the menu or menu item
     * @param title the title of the menu or menu item
     * @param mnemonic the mnemonic for the menu or menu item
     * @param accelerator the accelerator for the menu or menu item
     * @param style the style from the dialog model
     */
    @Deprecated
    protected MenuBase(String id, String dialogId, String title, String mnemonic, String accelerator, String style) {
    	this(id, dialogId, title, mnemonic, accelerator, style, null, null);
    }
    
    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * @return the mnemonic
     */
    public String getMnemonic() {
        return mnemonic;
    }

    /**
     * @param mnemonic the mnemonic to set
     */
    public void setMnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    /**
     * @return the accelerator
     */
    public String getAccelerator() {
        return accelerator;
    }

    /**
     * @param accelerator the accelerator to set
     */
    public void setAccelerator(String accelerator) {
        this.accelerator = accelerator;
    }

    /**
     * @return the dialogId
     */
    public String getDialogId() {
        return dialogId;
    }

    /**
     * @param dialogId the dialogId to set
     */
    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    /**
     * @return the applicationId
     */
    public String getApplicationId() {
        return applicationId;
    }

    /**
     * @param applicationId the applicationId to set
     */
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    /**
     * @return the style
     */
    public String getStyle() {
        return style;
    }

    /**
     * @param style the style to set
     */
    public void setStyle(String style) {
        this.style = style;
    }

    /**
	 * @return the image
	 */
	public ImageInfo getImage() {
		return image;
	}

	/**
	 * @param image the image to set
	 */
	public void setImage(ImageInfo image) {
		this.image = image;
	}

	/**
	 * @return the disabledImage
	 */
	public ImageInfo getDisabledImage() {
		return disabledImage;
	}

	/**
	 * @param disabledImage the disabledImage to set
	 */
	public void setDisabledImage(ImageInfo disabledImage) {
		this.disabledImage = disabledImage;
	}

	/**
     * @return the parent
     */
    public Menu getParent() {
        return parent;
    }

    /**
     * @param parent the parent to set
     */
    public void setParent(Menu parent) {
        this.parent = parent;
    }

}
