/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import no.g9.client.core.view.ImageInfo;

/**
 * A menu item from the dialog model.
 */
public class MenuItem extends MenuBase {

    private Map<String, List<String>> methods = new HashMap<String, List<String>>();

    /**
     * Create a new menu item without an event.
     *
     * @param id the ID of the menu item
     * @param dialogId the ID of the dialog which owns the menu item
     * @param title the title of the menu or menu item
     * @param mnemonic the mnemonic for the menu or menu item
     * @param accelerator the accelerator for the menu or menu item
     * @param style the style from the dialog model
     */
    public MenuItem(String id, String dialogId, String title, String mnemonic, String accelerator, String style) {
        this(id, dialogId, title, mnemonic, accelerator, style, null, null, null, null);
    }

    /**
     * Create a new menu item with the given event and method.
     *
     * @param id the ID of the menu item
     * @param dialogId the ID of the dialog which owns the menu item
     * @param title the title of the menu or menu item
     * @param mnemonic the mnemonic for the menu or menu item
     * @param accelerator the accelerator for the menu or menu item
     * @param style the style from the dialog model
     * @param event an event triggered by this menu item
     * @param method the method triggered by the given event
     */
    @Deprecated
    public MenuItem(String id, String dialogId, String title, String mnemonic, String accelerator, String style, String event, String method) {
        super(id, dialogId, title, mnemonic, accelerator, style, null, null);
        if (event != null && !event.isEmpty() && method != null && !method.isEmpty()) {
            addMethod(event, method);
        }
    }

    /**
     * Create a new menu item with the given event and method.
     *
     * @param id the ID of the menu item
     * @param dialogId the ID of the dialog which owns the menu item
     * @param title the title of the menu or menu item
     * @param mnemonic the mnemonic for the menu or menu item
     * @param accelerator the accelerator for the menu or menu item
     * @param style the style from the dialog model
     * @param image the image from the dialog model
     * @param disabledImage the disabled image from the dialog model
     * @param event an event triggered by this menu item
     * @param method the method triggered by the given event
     */
    public MenuItem(String id, String dialogId, String title, String mnemonic, String accelerator, String style, ImageInfo image,
    		ImageInfo disabledImage, String event, String method) {
    	super(id, dialogId, title, mnemonic, accelerator, style, image, disabledImage);
    	if (event != null && !event.isEmpty() && method != null && !method.isEmpty()) {
    		addMethod(event, method);
    	}
    }
    
    /**
     * Add a new method for the given event.
     *
     * @param event the event which triggers the method
     * @param method the method to trigger
     */
    public void addMethod(String event, String method) {
        if (!methods.containsKey(event)) {
            methods.put(event, new ArrayList<String>());
        }
        methods.get(event).add(method);
    }

    /**
     * @return the methods
     */
    public Map<String, List<String>> getMethods() {
        return methods;
    }

    /**
     * @param methods the methods to set
     */
    public void setMethods(Map<String, List<String>> methods) {
        this.methods = methods;
    }

    @Override
    public String toString() {
        return "MenuItem [id=" + getId() + "/" + getDialogId() + "]";
    }

}
