/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.tree;

import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.ListRow;

/**
 * The general tree node representation. Data of a node is kept in a <code>ListRow</code>.
 *
 */
public interface TreeNode {

	/**
	 * Returns the ListRow connected to a node.
	 * @param <L> list row
	 * 
	 * @return the ListRow associated with a node
	 */
	<L extends ListRow> L getListRow();

	/**
	 * Returns the dialog object constant for a node.
	 * 
	 * @return dialog object constant for node
	 */
	DialogObjectConstant getNodeConst();

}
