/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.spreadsheet;

/**
 * The class holds a cell.
 *
 */
public class G9ExcelCell {

	/** The column of the cell. */
	private int column;

	/** The row of the cell. */
	private int row;

	/**
	 * @return the column
	 */
	public int getColumn() {
		return column;
	}

	/**
	 * @return the row
	 */
	public int getRow() {
		return row;
	}

	/**
	 * Constructor setting the coordinates.
	 *
	 * @param column The column
	 * @param row The row
	 */
	public G9ExcelCell(final int column, final int row) {
		this.column = column;
		this.row = row;
	}

	/**
	 * Returns a {@code String} containing {@code G9ExcelCell(}"row number" {@code ,} "column number"{@code )}
	 */
	@Override
    public String toString() {
		return "G9ExcelCell (" + getRow() + ", " + getColumn() + ")";
	}

}
