/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.spreadsheet;

import java.io.File;
import java.io.OutputStream;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;
import no.g9.client.core.controller.DialogConstant;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

/**
 * The interface handles export to spreadsheets, such as Excel.
 * <br>
 * The implementation to be used at runtime can be controlled
 * by configuring a "spreadsheetService" Spring bean, or by setting
 * the "SpreadsheetService" property in the "g9.config.properties" file.
 * <br>
 * The default is to use <code>no.g9.client.spreadsheet.DefaultSpreadsheetService</code>.
 */
@BeanID("spreadsheetService")
@G9PropertyName("SpreadsheetService")
public interface SpreadsheetService {

    /**
     * Export data from the given dialog to a spreadsheet.
     * The dialog data is transferred in the os parameter.
     *
     * @param os The dialog data to export
     * @param targetDialog The dialog to export
     * @param file The resulting spreadsheet file
     * @return An object containing the exported workbook
     */
	SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, File file);

    /**
     * Export data from the given dialog to a spreadsheet.
     * The dialog data is transferred in the os parameter.
     *
     * @param os The dialog data to export
     * @param targetDialog The dialog to export
     * @param outputStream The output stream for the exported data
     * @return An object containing the exported workbook
     */
	SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, OutputStream outputStream);

    /**
     * Export data from the given dialog to a spreadsheet.
     * The dialog data is transferred in the os parameter.
     *
     * @param os The dialog data to export
     * @param targetDialog The dialog to export
     * @param file The resulting spreadsheet file
     * @param ctx The client context, which may be used to send exporter parameters
     * @return An object containing the exported workbook
     */
	SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, File file, ClientContext ctx);

    /**
     * Export data from the given dialog to a spreadsheet.
     * The dialog data is transferred in the os parameter.
     *
     * @param os The dialog data to export
     * @param targetDialog The dialog to export
     * @param outputStream The output stream for the exported data
     * @param ctx The client context, which may be used to send exporter parameters
     * @return An object containing the exported workbook
     */
	SpreadsheetExporter exportToSpreadsheet(ObjectSelection os, DialogConstant targetDialog, OutputStream outputStream, ClientContext ctx);

    /**
     * @return the file suffix used for the exported data
     */
    String getFileSuffix();

    /**
     * @return the MIME type used for the exported data
     */
    String getMimeType();
}
