/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import no.esito.jvine.action.HookProviderImpl;
import no.esito.log.Logger;
import no.esito.util.BeanID;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.DialogInteraction;
import no.g9.client.core.controller.DialogCallBackValue;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogSetupValue;

@BeanID(value="dialogInteractionBroker")
public class DialogInteractionBroker {
    private static final Logger log = Logger.getLogger(DialogInteractionBroker.class);

    private DialogInteractionBroker() {
    }

    public DialogSetupValue<?> doSetup(DialogSetupValue<?> provided, DialogController caller, DialogConstant callee) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Interaction hooks for interaction setup between caller:" + caller + ", and callee: " + callee + ". \n\tProvided setup value is: " + provided));
        }
        Collection<DialogInteraction> interactionHook = this.getInteractionHook(caller, callee);
        for (DialogInteraction dialogInteraction : interactionHook) {
            provided = dialogInteraction.getSetupValue(provided, caller, callee);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("After running provided setup value through hooks, the value is: " + provided));
        }
        return provided;
    }

    public DialogCallBackValue doCallback(DialogCallBackValue provided, DialogController caller, DialogConstant callee) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Interaction hooks for callback interaction between caller:" + caller + ", and callee: " + callee + ". \n\tProvided call back value is: " + provided));
        }
        Collection<DialogInteraction> interactionHook = this.getInteractionHook(caller, callee);
        for (DialogInteraction dialogInteraction : interactionHook) {
            provided = dialogInteraction.getActionReturnValue(provided, caller, callee);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("After running provided call back value through hooks, the value is: " + provided));
        }
        return provided;
    }

    public static DialogInteractionBroker getInstance() {
        DialogInteractionBroker retVal = (DialogInteractionBroker)ServiceLoader.getService(DialogInteractionBroker.class);
        return retVal;
    }

    private Collection<DialogInteraction> getInteractionHook(DialogController caller, DialogConstant callee) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting interaction hooks for caller: " + caller + " and callee: " + callee));
        }
        HookProviderImpl hookProvider = HookProviderImpl.getInstance();
        List<DialogInteraction> listCaller = hookProvider.getCallerInteractionHook(this.getCaller(caller));
        List<DialogInteraction> listCallee = hookProvider.getCalleeInteractionHook(callee);
        Sets.SetView setFinal = Sets.intersection((Set)Sets.newHashSet(listCaller), (Set)Sets.newHashSet(listCallee));
        ArrayList listFinal = Lists.newArrayList((Iterable)setFinal);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got interaction hooks: " + listFinal));
        }
        return listFinal;
    }

    private DialogConstant getCaller(DialogController caller) {
        return caller != null ? caller.getDialogConstant() : null;
    }
}

