/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.controller;

import java.io.ByteArrayOutputStream;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.ActionTask;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.view.Resource;
import no.g9.client.core.view.ResourceStore;
import no.g9.client.spreadsheet.SpreadsheetExporter;
import no.g9.client.spreadsheet.SpreadsheetService;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

final class SpreadsheetAction
extends ActionTask<Resource> {
    private static final Logger log = Logger.getLogger(SpreadsheetAction.class);
    private static final boolean PURGE = true;
    private final DialogConstant targetDialog;
    private final ByteArrayOutputStream spreadsheetBytes;
    private final SpreadsheetService spreadsheetService = (SpreadsheetService)ServiceLoader.getService(SpreadsheetService.class);
    private final ResourceStore resourceStore = (ResourceStore)ServiceLoader.getService(ResourceStore.class);
    private final ApplicationController appCtrl;

    SpreadsheetAction(DialogConstant target, ApplicationController appCtrl) {
        this.targetDialog = target;
        this.appCtrl = appCtrl;
        this.spreadsheetBytes = new ByteArrayOutputStream();
    }

    @Override
    public Resource call() throws Exception {
        Object[] taskObject = (Object[])this.getTaskObject();
        ObjectSelection os = (ObjectSelection)taskObject[0];
        ClientContext ctx = (ClientContext)taskObject[1];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting " + this + " as a spreadsheet resource"));
        }
        SpreadsheetExporter exporter = this.spreadsheetService.exportToSpreadsheet(os, this.targetDialog, this.spreadsheetBytes, ctx);
        Object dc = this.appCtrl.getDialogController(this.targetDialog);
        if (dc != null) {
            ((DialogController)dc).setSpreadsheetExporter(exporter);
        }
        Resource xlResource = new Resource(this.targetDialog.getG9Name() + this.spreadsheetService.getFileSuffix(), this.spreadsheetService.getMimeType(), this.spreadsheetBytes.toByteArray());
        this.resourceStore.putResource(xlResource);
        this.appCtrl.getApplicationView().openResource(xlResource.getId(), true);
        return xlResource;
    }

    @Override
    public String toString() {
        return "SpreadsheetAction [targetDialog=" + this.targetDialog + "]";
    }
}

