/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.TreeNode;
import no.esito.jvine.model.TreeNodeSentinel;
import no.esito.log.Logger;
import no.g9.client.core.controller.RoleState;
import no.g9.os.AttributeConstant;
import no.g9.os.Key;
import no.g9.os.KeyTool;
import no.g9.os.RelationCardinality;
import no.g9.os.RelationType;

public class TreeNodeImpl<T>
implements TreeNode<T> {
    private static final Logger log = Logger.getLogger(TreeNodeImpl.class);
    private T current;
    private final TreeNode<?> parent;
    private final OSNode<T> osNode;
    private final Collection<TreeNode<?>> children;

    public TreeNodeImpl(TreeNode<?> parent, OSNode<T> osNode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating tree node for " + osNode + " with parent " + parent));
        }
        this.parent = parent;
        this.osNode = osNode;
        this.children = new ArrayList();
    }

    @Override
    public TreeNode<?> getParent() {
        return this.parent;
    }

    @Override
    public Collection<TreeNode<?>> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(TreeNode<?> child) {
        this.children.add(child);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " added child " + child));
        }
    }

    @Override
    public Collection<OSNode<?>> setCurrentInstance(T current) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " setting " + current + " as current instance," + " and propagating change to children."));
        }
        this.updateCurrent(current);
        this.setClean();
        return this.changed();
    }

    @Override
    public Collection<OSNode<?>> setCurrentRootInstances(Collection<T> instances) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering current on root's sentinel.");
        }
        if (this.getOSNode().getRelationType() != RelationType.ROOT) {
            String msg = this.getOSNode().toString() + " is not a root node." + " Only root nodes can set a collection of current instances.";
            throw new UnsupportedOperationException(msg);
        }
        ((TreeNodeSentinel)this.parent).addRootInstances(this.osNode, instances);
        this.setCleared();
        return this.changed();
    }

    private List<OSNode<?>> changed() {
        LinkedList changed = new LinkedList();
        changed.add(this.osNode);
        for (TreeNode<?> child : this.getChildren()) {
            changed.addAll(child.computeCurrent());
        }
        return changed;
    }

    @Override
    public Collection<OSNode<?>> computeCurrent() {
        RelationCardinality cardinality = this.getOSNode().getCardinality();
        if (cardinality == RelationCardinality.MANY) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " is many-related. Clearing current and all " + " children."));
            }
            Collection<OSNode<?>> cleared = this.clear(false);
            this.setCleared();
            return cleared;
        }
        Collection<T> instances = this.getInstances();
        if (instances.size() > 1) {
            String msg = "Encounterend more than one instance when getting instances for the " + this.getOSNode() + " role";
            throw new RuntimeException(msg);
        }
        if (instances.isEmpty()) {
            this.updateCurrent(null);
            this.setClean();
        } else {
            for (T tmp : instances) {
                this.updateCurrent(tmp);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " current selected " + this.current));
                }
                if (this.current != null) {
                    this.setClean();
                    continue;
                }
                this.setCleared();
            }
        }
        LinkedList changed = new LinkedList();
        changed.add(this.getOSNode());
        for (TreeNode<?> child : this.getChildren()) {
            changed.addAll(child.computeCurrent());
        }
        return changed;
    }

    @Override
    public T getCurrentInstance() {
        return this.current;
    }

    @Override
    public Object getChildRelation(OSNode<?> child) {
        if (this.getCurrentInstance() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " cannot get relation to " + child + " since current parent is null"));
            }
            return null;
        }
        return this.getOSNode().getRelation(this.getCurrentInstance(), child.getRoleConstant());
    }

    @Override
    public Collection<T> getInstances() {
        boolean isRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " getting instances"));
        }
        Object parentToThis = this.getParent().getChildRelation(this.getOSNode());
        boolean bl = isRoot = this.getOSNode().getRelationCardinality() == RelationCardinality.ROOT;
        if (isRoot && parentToThis == null) {
            parentToThis = this.getCurrentInstance();
        }
        Collection<Object> instances = Collections.EMPTY_SET;
        if (parentToThis instanceof Collection) {
            instances = (Collection)parentToThis;
            if (instances instanceof Set) {
                Object currentParent;
                LinkedHashSet<T> tmp = new LinkedHashSet<T>();
                tmp.addAll(instances);
                instances = tmp;
                if (!isRoot && (currentParent = this.getParent().getCurrentInstance()) != null) {
                    this.getOSNode().getParent().setRelation(currentParent, instances, this.getOSNode().getRoleConstant());
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Relation is a collection, no further action is needed.");
            }
        } else if (parentToThis != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Relation is a single object. Creating a collection to store it in.");
            }
            instances = new LinkedHashSet<T>(1);
            instances.add(this.getOSNode().castToType(parentToThis));
        } else if (this.getCurrentInstance() != null) {
            instances = new LinkedHashSet(1);
            instances.add(this.getCurrentInstance());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " when asked for instances returns " + instances));
        }
        return instances;
    }

    @Override
    public OSNode<T> getOSNode() {
        return this.osNode;
    }

    @Override
    public Collection<OSNode<?>> clearCurrent(boolean intercept) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " clearing node."));
        }
        LinkedHashSet changedNodes = new LinkedHashSet();
        changedNodes.add(this.getOSNode());
        this.updateCurrent(null);
        for (TreeNode<?> child : this.getChildren()) {
            changedNodes.addAll(child.clear(intercept));
        }
        return changedNodes;
    }

    @Override
    public Collection<OSNode<?>> clear(boolean intercept) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " clearing node."));
        }
        LinkedHashSet changedNodes = new LinkedHashSet();
        changedNodes.add(this.getOSNode());
        this.updateCurrent(null);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " clearing current"));
        }
        if (this.getOSNode().getRelationType() == RelationType.ROOT) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " clearing the sentinel."));
            }
            ((TreeNodeSentinel)this.parent).clearRootInstance(this.getOSNode());
        }
        for (TreeNode<?> child : this.getChildren()) {
            changedNodes.addAll(child.clear(intercept));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " cleared nodes are: " + changedNodes));
        }
        this.setCleared();
        return changedNodes;
    }

    private void setCleared() {
        this.getOSNode().setState(RoleState.CLEARED);
        this.getOSNode().resetState();
    }

    @Override
    public Collection<OSNode<?>> removeCurrent() {
        this.updateCurrent(null);
        return Arrays.asList(this.getOSNode());
    }

    public String toString() {
        return "TreeNode [" + this.getOSNode() + "]";
    }

    private void setClean() {
        this.getOSNode().setState(RoleState.CLEAN);
        this.getOSNode().resetState();
    }

    private void updateCurrent(T newCurrent) {
        Object currentParent;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting current to: " + newCurrent));
        }
        this.current = newCurrent;
        if (this.getOSNode().isMany()) {
            Collection<T> instances = this.getInstances();
            if (newCurrent != null && instances != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Adding instance to complete set of instances.");
                }
                this.removeInstance(instances, newCurrent);
                instances.add(newCurrent);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Instances: " + instances));
                }
            }
        } else if (!this.getOSNode().isRoot() && (currentParent = this.getParent().getCurrentInstance()) != null) {
            this.getParent().getOSNode().setRelation(currentParent, newCurrent, this.getOSNode().getRoleConstant());
        }
    }

    private void removeInstance(Collection<T> instances, T instance) {
        Key equalsKey;
        List<Key> keys;
        if (!instances.remove(instance) && !(keys = this.getOSNode().getKeys()).isEmpty() && (equalsKey = keys.get(0)).getAttributes().length == 1) {
            for (T possibleInstance : instances) {
                if (!this.getOSNode().matchUniqueKeys(possibleInstance, instance, false)) continue;
                instances.remove(possibleInstance);
                return;
            }
            AttributeConstant equalsAttribute = equalsKey.getAttributes()[0];
            for (T possibleInstance : instances) {
                Object equalsValue = this.getOSNode().getValue(possibleInstance, equalsAttribute);
                if (KeyTool.isDefined((Object)equalsValue) || !this.equalsUsingAttributes(this.getOSNode().getAttributeConstants(), equalsAttribute, possibleInstance, instance)) continue;
                instances.remove(possibleInstance);
                return;
            }
        }
    }

    private boolean equalsUsingAttributes(AttributeConstant[] attributes, AttributeConstant excludedAttribute, T anObject, T anOtherObject) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " equals using attributes " + Arrays.toString(attributes)));
        }
        if (anObject == anOtherObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        boolean foundMatch = true;
        for (int i = 0; i < attributes.length && foundMatch; ++i) {
            if (attributes[i] == excludedAttribute) continue;
            Object value1 = this.getOSNode().getValue(anObject, attributes[i]);
            Object value2 = this.getOSNode().getValue(anOtherObject, attributes[i]);
            if (value1 != null && value2 != null) {
                boolean bl = foundMatch = KeyTool.isDefined((Object)value1) && KeyTool.isDefined((Object)value2);
                if (foundMatch) {
                    foundMatch = value1.equals(value2);
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Comparing values in " + attributes[i] + ", value1: " + value1 + ", value2: " + value2 + ", equals so far: " + foundMatch));
        }
        return foundMatch;
    }
}

