/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.rpc;

import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.log.Logger;
import no.g9.client.core.action.Parameter;
import no.g9.client.core.controller.DialogController;
import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;

public class ActualParameter<T>
implements Parameter<T> {
    private static final Logger log = Logger.getLogger(ActualParameter.class);
    private final String parameterName;
    private final ParameterType parameterType;
    private T parameterValue = null;
    private RoleConstant role;
    private AttributeConstant attribute;
    private final DialogController dialogController;
    private boolean isObtained;

    public ActualParameter(DialogController dialogController, String parameterName, ParameterType parameterType) {
        this.dialogController = dialogController;
        this.parameterName = parameterName;
        this.parameterType = parameterType;
    }

    @Override
    public final String getParameterName() {
        return this.parameterName;
    }

    public final boolean isConstant() {
        return this.getParameterType() == ParameterType.CONSTANT;
    }

    public final boolean isRole() {
        return this.getParameterType() == ParameterType.ROLE;
    }

    public final boolean isAttribute() {
        return this.getParameterType() == ParameterType.ATTRIBUTE;
    }

    public final ParameterType getParameterType() {
        return this.parameterType;
    }

    @Override
    public final T getParameterValue() {
        return this.parameterValue;
    }

    @Override
    public final void setParameterValue(T parameterValue) {
        this.parameterValue = parameterValue;
    }

    public RoleConstant getRole() {
        return this.role;
    }

    public void setRole(RoleConstant role) {
        this.role = role;
        if (this.parameterType == ParameterType.CONSTANT && role != null) {
            throw new IllegalArgumentException("Constant parameter cannot have an associated role");
        }
    }

    public AttributeConstant getAttribute() {
        return this.attribute;
    }

    public void setAttribute(AttributeConstant attribute) {
        this.attribute = attribute;
        if (this.parameterType != ParameterType.ATTRIBUTE && attribute == null) {
            throw new IllegalArgumentException("Attribute constant only allowed for actual parameters of type ATTRIBUTE");
        }
    }

    public T obtainValue() {
        T value = null;
        switch (this.parameterType) {
            case UNBOUND: {
                log.debug((Object)"Obtaining unbound - nothing to obtain");
                break;
            }
            case CONSTANT: {
                log.debug((Object)"Obtaining constant - nothing to obtain");
                value = this.getParameterValue();
                break;
            }
            case ATTRIBUTE: {
                log.debug((Object)"Obtaining attribute - getting field value");
                value = this.dialogController.getFieldValue(this.attribute);
                break;
            }
            case ROLE: {
                log.debug((Object)"Obtaining role");
                JVineController jController = JVineController.getInstance(this.dialogController);
                OSNode osNode = jController.getOSNode(this.role);
                value = osNode.obtain(false);
                break;
            }
            default: {
                String msg = "Unknown actual parameter type " + (Object)((Object)this.parameterType);
                throw new RuntimeException(msg);
            }
        }
        this.isObtained = true;
        return value;
    }

    public boolean isObtained() {
        return this.isObtained;
    }

    public String toString() {
        return "ActualParameter [" + (this.parameterName != null ? "parameterName=" + this.parameterName + ", " : "") + (this.parameterType != null ? "parameterType=" + (Object)((Object)this.parameterType) + ", " : "") + (this.attribute != null ? "attribute=" + this.attribute + ", " : "") + (this.role != null ? "role=" + this.role + ", " : "") + (this.parameterValue != null ? "parameterValue=" + this.parameterValue + ", " : "") + "isObtained=" + this.isObtained + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.parameterName == null ? 0 : this.parameterName.hashCode());
        result = 31 * result + (this.parameterType == null ? 0 : this.parameterType.hashCode());
        result = 31 * result + (this.parameterValue == null ? 0 : this.parameterValue.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActualParameter)) {
            return false;
        }
        ActualParameter other = (ActualParameter)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        if (this.parameterName == null ? other.parameterName != null : !this.parameterName.equals(other.parameterName)) {
            return false;
        }
        if (this.parameterType == null ? other.parameterType != null : !this.parameterType.equals((Object)other.parameterType)) {
            return false;
        }
        if (this.parameterValue == null ? other.parameterValue != null : !this.parameterValue.equals(other.parameterValue)) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }

    public static enum ParameterType {
        CONSTANT,
        ROLE,
        ATTRIBUTE,
        UNBOUND;

    }
}

