/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.view;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import no.esito.jvine.action.GuiTask;
import no.esito.jvine.action.ThreadManager;
import no.esito.jvine.controller.DialogInstanceKey;
import no.esito.jvine.controller.JVineApplicationController;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.util.ViewConstantHelper;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.jvine.view.ViewModelImpl;
import no.esito.log.Logger;
import no.g9.client.core.action.CheckType;
import no.g9.client.core.action.EventContext;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.ListSelectionCallback;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.WindowEvent;
import no.g9.client.core.view.table.TableModel;
import no.g9.client.core.view.tree.TreeModel;
import no.g9.client.core.view.tree.TreeNode;
import no.g9.message.Message;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageSystem;
import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;
import no.g9.service.G9Spring;
import no.g9.support.ActionType;
import no.g9.support.convert.ConvertException;

public abstract class AbstractDialogView
implements DialogView {
    private DialogInstance instance;
    private DialogConstant tmpDialog;
    private int currentRowNum;
    private boolean isOpen;
    private boolean isShown;
    private boolean modal;
    private AbstractApplicationView applicationView;
    private Map<DialogObjectConstant, DialogObjectConstant> currentNotebookPage = new HashMap<DialogObjectConstant, DialogObjectConstant>();
    private Map<DialogObjectConstant, Map<ActionType, String>> effects = new HashMap<DialogObjectConstant, Map<ActionType, String>>();
    private DialogObjectConstant defaultButton;
    protected static final Logger log = Logger.getLogger(DialogView.class);

    public AbstractDialogView(DialogConstant dialog) {
        this.tmpDialog = dialog;
        this.modal = false;
    }

    @Override
    public void update(Collection<OSNode<?>> nodes) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating  " + nodes));
        }
        for (OSNode<?> node : nodes) {
            Collection<?> instances = JVineController.getInstance(this.getDialogController()).getAllInstances(node);
            this.setAllFieldData(node, instances);
        }
    }

    @Override
    public void performAction(ActionType action, DialogObjectConstant target) {
        Object effectBean;
        if (log.isTraceEnabled()) {
            log.trace((Object)("performAction: " + action + " " + target));
        }
        if ((effectBean = this.getEffectBean(target, action)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("performAction, setting effect: " + this.getEffectBeanId(target, action)));
            }
            ViewModelImpl model = (ViewModelImpl)this.getViewModel();
            model.getPropertyManager().setEffect(target, effectBean);
        }
        switch (action) {
            case HIDE: {
                if (effectBean != null) break;
                this.hide(target);
                break;
            }
            case SHOW: {
                if (effectBean != null) break;
                this.show(target);
                break;
            }
            case ENABLE: {
                this.enable(target);
                break;
            }
            case DISABLE: {
                this.disable(target);
                break;
            }
            case CLEAROBJECT: {
                this.clearObject(target);
                break;
            }
            case FOCUS: {
                this.focus(target);
                break;
            }
            case UNSELECT: {
                this.unselect(target);
                break;
            }
            case SELECT: {
                this.select(target);
                break;
            }
            default: {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)("Dialog action not handled: " + action));
            }
        }
    }

    private void select(DialogObjectConstant target) {
        ViewModelImpl view = (ViewModelImpl)this.getViewModel();
        RoleConstant role = target.getRole();
        view.setListRowSelection(true, role, this.currentRowNum, null);
    }

    private void unselect(DialogObjectConstant target) {
        ViewModelImpl view = (ViewModelImpl)this.getViewModel();
        RoleConstant role = target.getRole();
        view.setListRowSelection(false, role, this.currentRowNum, null);
    }

    @Override
    public boolean isEditable(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        return model.getPropertyManager().isEditable(target);
    }

    @Override
    public boolean isEnabled(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        return model.getPropertyManager().isEnabled(target);
    }

    @Override
    public String getTitle(DialogObjectConstant dialogObject) {
        String messageID = dialogObject.getMessageID();
        if (messageID == null) {
            return null;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.getMessageBundleName());
        return bundle.getString(messageID);
    }

    @Override
    public void setDialogTitle(String title) {
        this.getApplicationView().setDialogTitle(this.getDialogInstance(), title);
    }

    public abstract String getMessageBundleName();

    @Override
    public boolean isMandatory(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        return model.getPropertyManager().isMandatory(target);
    }

    @Override
    public boolean isShown(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        return model.getPropertyManager().isShown(target);
    }

    @Override
    public void setModal(boolean modal) {
        this.modal = modal;
    }

    @Override
    public boolean isModal() {
        return this.modal;
    }

    @Override
    public Object getEffect(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        return model.getPropertyManager().getEffect(target);
    }

    @Override
    public void setEditable(DialogObjectConstant target, boolean value) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setEditable(target, value);
    }

    @Override
    public void setMandatory(DialogObjectConstant target, boolean value) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setMandatory(target, value);
    }

    @Override
    public boolean getMandatory(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        return model.getPropertyManager().getMandatory(target);
    }

    @Override
    public void setEffect(DialogObjectConstant target, Object effect) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setEffect(target, effect);
    }

    @Override
    public void enable(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setEnabled(target, true);
    }

    @Override
    public void disable(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setEnabled(target, false);
    }

    @Override
    public void show(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setShown(target, true);
    }

    @Override
    public void hide(DialogObjectConstant target) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.getPropertyManager().setShown(target, false);
    }

    @Override
    public void setWidgetProperty(DialogObjectConstant target, String key, Object value) {
        if (target != null) {
            ViewModelImpl model = (ViewModelImpl)this.getViewModel();
            model.getPropertyManager().setProperty(target, key, value);
        }
    }

    @Override
    public Object getWidgetProperty(DialogObjectConstant target, String key) {
        if (target != null) {
            ViewModelImpl model = (ViewModelImpl)this.getViewModel();
            return model.getPropertyManager().getProperty(target, key);
        }
        return null;
    }

    @Override
    public void setCurrentNotebookPage(DialogObjectConstant notebook, DialogObjectConstant page) {
        this.currentNotebookPage.put(notebook, page);
    }

    @Override
    public DialogObjectConstant getCurrentNotebookPage(DialogObjectConstant notebook) {
        return this.currentNotebookPage.get(notebook);
    }

    @Override
    public ViewModel getViewModel() {
        return this.getApplicationView().getViewModel(this.instance);
    }

    public DialogConstant getDialog() {
        return this.instance.getDialogConstant();
    }

    public DialogInstance getDialogInstance() {
        return this.instance;
    }

    protected DialogController getDialogController() {
        return this.applicationView.getDialogController(this.instance);
    }

    @Override
    public int getDialogInstanceNumber() {
        return this.instance.getDialogInstanceNumber();
    }

    protected void setDialogInstanceNumber(int dialogInstanceNumber) {
        this.instance = new DialogInstanceKey(this.tmpDialog, dialogInstanceNumber);
    }

    public AbstractApplicationView getApplicationView() {
        return this.applicationView;
    }

    public void setApplicationView(AbstractApplicationView applicationView) {
        this.applicationView = applicationView;
        this.initView();
    }

    protected void initView() {
        this.init();
    }

    public abstract void setAllFieldData(OSNode<?> var1, Collection<?> var2);

    protected abstract void focus(DialogObjectConstant var1);

    @Override
    public void dispatchEvent(ListRow listRow, DialogObjectConstant trigger, Object event, String method) {
        if (this.canDispatchEvents()) {
            this.setThreadApplicationController();
            EventContext eventMethod = new EventContext(method, trigger, event, listRow);
            JVineController.getInstance(this.getDialogController()).dispatch(eventMethod);
        }
    }

    public boolean canDispatchEvents() {
        return !this.applicationView.getShowMessage() && this.isOpen() && this.isShown() && this.getDialogController() != null;
    }

    protected void dispatchEvent(DialogObjectConstant trigger, String type, String method) {
        this.dispatchEvent(null, trigger, type, method);
    }

    protected abstract void triggerWindowEvent(WindowEvent var1);

    public void clearDialog() {
        this.getViewModel().clearViewModel();
    }

    @Override
    public void clearObject(DialogObjectConstant target) {
        if (this.isListComponent(target)) {
            RoleConstant listRole = this.getListRole(target);
            this.getViewModel().getTableModel(listRole).clear();
        } else {
            AttributeConstant attribute = target.getAttribute();
            if (attribute != null) {
                this.getViewModel().setFieldValue(target, null);
            }
        }
        Collection<DialogObjectConstant> children = ViewConstantHelper.getChildren(target);
        for (DialogObjectConstant childTarget : children) {
            this.clearObject(childTarget);
        }
    }

    public String getEffectBeanId(DialogObjectConstant target, ActionType action) {
        String effectBeanId = null;
        Map<ActionType, String> targetEffects = this.effects.get(target);
        if (targetEffects != null) {
            effectBeanId = targetEffects.get(action);
        }
        return effectBeanId;
    }

    public void setEffectBeanId(DialogObjectConstant target, ActionType action, String effectBeanId) {
        Map<ActionType, String> targetEffects = this.effects.get(target);
        if (targetEffects == null) {
            targetEffects = new HashMap<ActionType, String>();
            this.effects.put(target, targetEffects);
        }
        targetEffects.put(action, effectBeanId);
    }

    public Object getEffectBean(DialogObjectConstant target, ActionType action) {
        String effectBeanId = this.getEffectBeanId(target, action);
        if (effectBeanId != null) {
            return G9Spring.getBean((String)effectBeanId);
        }
        return null;
    }

    @Override
    public DialogObjectConstant getDefaultButton() {
        return this.defaultButton;
    }

    @Override
    public void setDefaultButton(DialogObjectConstant defaultButton) {
        this.defaultButton = defaultButton;
    }

    private boolean isListComponent(DialogObjectConstant target) {
        Map<DialogObjectConstant, RoleConstant> listRoles = this.getListRoles();
        if (listRoles != null) {
            return listRoles.keySet().contains(target);
        }
        return false;
    }

    private RoleConstant getListRole(DialogObjectConstant listComponent) {
        Map<DialogObjectConstant, RoleConstant> listRoles = this.getListRoles();
        if (listRoles != null) {
            return listRoles.get(listComponent);
        }
        return null;
    }

    private Map<DialogObjectConstant, RoleConstant> getListRoles() {
        ViewModel viewModel = this.getViewModel();
        if (viewModel instanceof ViewModelImpl) {
            ViewModelImpl viewModelImpl = (ViewModelImpl)viewModel;
            return viewModelImpl.getListRoles();
        }
        return null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    protected boolean isShown() {
        return this.isShown;
    }

    protected void setShown(boolean isShown) {
        this.isShown = isShown;
    }

    protected Object getFieldValue(DialogObjectConstant field) {
        return this.getViewModel().getFieldValue(field);
    }

    protected void setFieldValue(DialogObjectConstant field, Object fieldValue) {
        this.getViewModel().setFieldValue(field, fieldValue);
    }

    protected Collection<DialogObjectConstant> getRoleFields(RoleConstant role) {
        return this.getViewModel().getRoleFields(role);
    }

    protected void addRoleField(RoleConstant role, DialogObjectConstant field) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.addRoleField(role, field);
    }

    protected void addRoleList(RoleConstant role, DialogObjectConstant listConst, TableModel<? extends ListRow> tableModel) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.addRoleTableModel(role, listConst, tableModel);
    }

    protected void addTreeModel(DialogObjectConstant treeConst, TreeModel<? extends TreeNode, ? extends ListRow> treeModel) {
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        model.setTreeModel(treeConst, treeModel);
    }

    protected boolean handleListSelection(RoleConstant listRole, boolean selected, int rowNo, ListRow emptyRow) {
        boolean listSelectionChanged = true;
        log.debug((Object)"Handle list selection");
        boolean unchanged = this.getDialogController().checkChange(listRole, CheckType.ROW_SELECT);
        ViewModelImpl model = (ViewModelImpl)this.getViewModel();
        TableModel.SelectionModel selectionModel = model.getTableModel(listRole).getSelectionModel();
        if (unchanged || selectionModel == TableModel.SelectionModel.NO_SELECT) {
            log.debug((Object)"List row is unchanged.");
            listSelectionChanged = model.setListRowSelection(selected, listRole, rowNo, emptyRow);
            log.trace((Object)("Done setting list selection to model. List selection is " + (listSelectionChanged ? " changed" : "uncanged")));
        } else {
            log.debug((Object)"List row is changed.");
            ListSelectionCallback cb = new ListSelectionCallback(model, selected, listRole, rowNo, emptyRow);
            String msgNo = selected ? "-1605" : "-1606";
            MessageDispatcher messageDispatcher = this.applicationView.getMessageDispatcher(this.applicationView.getDispatcherContext(cb));
            messageDispatcher.dispatch(msgNo, (Object[])null);
            listSelectionChanged = false;
            log.trace((Object)"Asuming no list selection since message interaction with end user is asynchronous.");
        }
        return listSelectionChanged;
    }

    protected void setListSelectionRowNum(int rowNum) {
        this.currentRowNum = rowNum;
    }

    protected void guiInvoke(GuiTask method) {
        if (ThreadManager.isWorkerThread()) {
            try {
                this.getDialogController().invokeOnGui(method);
            }
            catch (InvocationTargetException e) {
                MessageDispatcher messageDispatcher = this.applicationView.getMessageDispatcher();
                Message msg = MessageSystem.getMessageFactory().getMessage("-1517", new Object[]{method.toString()});
                msg.setReplString("OK");
                msg.setException((Throwable)e);
                messageDispatcher.dispatch("-1517", new Object[]{msg});
            }
        } else {
            method.run();
        }
    }

    protected Object convertToView(DialogObjectConstant field, Object modelValue) {
        ViewModelImpl viewModel = (ViewModelImpl)this.getViewModel();
        Object viewValue = modelValue;
        if (ViewModelImpl.hasConverter(field)) {
            try {
                viewValue = viewModel.convertToViewInternal(field, modelValue);
            }
            catch (ConvertException e) {
                JVineController.getInstance(this.getDialogController()).addConverterException(e);
            }
        }
        return viewValue;
    }

    private void setThreadApplicationController() {
        JVineApplicationController.setCurrentApplicationController(this.getApplicationView().getApplicationController());
    }
}

