/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.action;

import java.util.ArrayList;
import java.util.List;
import no.g9.client.core.action.ActionHook;
import no.g9.client.core.action.Checkable;
import no.g9.client.core.action.Displayable;
import no.g9.client.core.action.G9Action;
import no.g9.client.core.action.Obtainable;

public class ActionHookList<T> {
    private List<ActionHook<T>> hookList = new ArrayList<ActionHook<T>>();

    public List<ActionHook<T>> getHooks() {
        return this.hookList;
    }

    List<Checkable> getCheckableHooks() {
        ArrayList<Checkable> hooks = new ArrayList<Checkable>();
        for (ActionHook<T> hook : this.getHooks()) {
            if (!(hook instanceof Checkable)) continue;
            hooks.add((Checkable)((Object)hook));
        }
        return hooks;
    }

    List<Obtainable> getObtainableHooks() {
        ArrayList<Obtainable> hooks = new ArrayList<Obtainable>();
        for (ActionHook<T> hook : this.getHooks()) {
            if (!(hook instanceof Obtainable)) continue;
            hooks.add((Obtainable)((Object)hook));
        }
        return hooks;
    }

    List<Displayable> getDisplayableHooks() {
        ArrayList<Displayable> hooks = new ArrayList<Displayable>();
        for (ActionHook<T> hook : this.getHooks()) {
            if (!(hook instanceof Displayable)) continue;
            hooks.add((Displayable)((Object)hook));
        }
        return hooks;
    }

    protected void setCurrentAction(G9Action<T> currentAction) throws InterruptedException {
        for (ActionHook<T> hook : this.hookList) {
            hook.setCurrentAction(currentAction);
        }
    }

    protected void removeCurrentAction(G9Action<T> action) throws InterruptedException {
        for (ActionHook<T> hook : this.hookList) {
            hook.removeCurrentAction(action);
        }
    }
}

