/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.communication;

public final class SystemMessage {
    public static final String ANY_RECEIVER = "";
    public static final String SYSTEM = "system";
    public static final String URL_RECEIVER = "system";
    public static final String URL_PORT = "url";
    public static final SystemMessage URL_TEMPLATE = new SystemMessage("system/url");
    public static final String STACK_RECEIVER = "system";
    public static final String STACK_PUSH_PORT = "stack_push";
    public static final String STACK_ELEVATE_PORT = "stack_elevate";
    public static final String STACK_POP_PORT = "stack_pop";
    public static final SystemMessage STACK_PUSH_TEMPLATE = new SystemMessage("system/stack_push");
    public static final SystemMessage STACK_ELEVATE_TEMPLATE = new SystemMessage("system/stack_elevate");
    public static final SystemMessage STACK_POP_TEMPLATE = new SystemMessage("system/stack_pop");
    public static final String QUERY_SETUP_RECEIVER = "system";
    public static final String QUERY_SETUP_PORT = "system";
    public static final SystemMessage QUERY_SETUP_TEMPLATE = new SystemMessage("system/system");
    public static final String MENU_PORT = "_application_menu";
    public static final String CALLBACK_PORT = "_call_back";
    public static final SystemMessage CALLBACK_TEMPLATE = new SystemMessage("/_call_back");
    public static final String ERROR_PORT = "_error_handler";
    public static final String ALERT_PORT = "alert";
    public static final String ALERT_RECEIVER = "system";
    public static final SystemMessage ALERT_TEMPLATE = new SystemMessage("system/alert");
    public static final String OPEN_PORT = "open";
    public static final String OPEN_RECEIVER = "system";
    public static final SystemMessage OPEN_TEMPLATE = new SystemMessage("system/open");
    public static final String ACTIVE_INSTANCE_PORT = "_active_instance";
    public static final SystemMessage ACTIVE_INSTANCE_TEMPLATE = new SystemMessage("/_active_instance");
    public static final String MESSAGE_ACTION_PERFORMER = "_perform_message_action";
    public final String receiver;
    public final String port;
    public final String payload;

    public SystemMessage(String codedMessage) {
        String[] split = codedMessage.split("[\\/\\\\]", 3);
        this.receiver = split.length >= 1 ? split[0] : ANY_RECEIVER;
        this.port = split.length >= 2 ? split[1] : ANY_RECEIVER;
        this.payload = split.length >= 3 ? split[2] : ANY_RECEIVER;
    }

    public SystemMessage(String receiver, String port, String payload) {
        this.receiver = receiver;
        this.port = port;
        this.payload = payload;
    }

    public String code() {
        return this.receiver + "/" + this.port + "/" + this.payload;
    }

    public String toString() {
        return "SystemMessage: " + this.code();
    }

    public SystemMessage receiver(String receiver) {
        return new SystemMessage(receiver, this.port, this.payload);
    }

    public SystemMessage port(String port) {
        return new SystemMessage(this.receiver, port, this.payload);
    }

    public SystemMessage payload(String payload) {
        return new SystemMessage(this.receiver, this.port, payload);
    }

    public SystemMessage payload(SystemMessage payload) {
        return new SystemMessage(this.receiver, this.port, payload.code());
    }
}

