/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import no.esito.util.DateUtil;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.util.RoleNameHelper;

public class QueryBuilder {
    public static Object[] buildAutoCompleteQueryWithParameters(String valueAttribute, List<String> columnAttributes, String columnValue, DialogController dialogController) {
        RoleNameHelper roleNameHelper = new RoleNameHelper(dialogController);
        String tableName = roleNameHelper.getTableName(valueAttribute);
        List<Object[]> colNames = QueryBuilder.getColumnNamesAndDataTypes(valueAttribute, columnAttributes, roleNameHelper);
        return QueryBuilder.buildQueryWithParameters(columnValue, tableName, colNames);
    }

    public static String buildAutoCompleteQuery(String valueAttribute, List<String> columnAttributes, String columnValue, DialogController dialogController) {
        RoleNameHelper roleNameHelper = new RoleNameHelper(dialogController);
        String tableName = roleNameHelper.getTableName(valueAttribute);
        List<Object[]> colNames = QueryBuilder.getColumnNamesAndDataTypes(valueAttribute, columnAttributes, roleNameHelper);
        return QueryBuilder.buildQuery(columnValue, tableName, colNames);
    }

    private static String buildQuery(String columnValue, String tableName, List<Object[]> colNames) {
        StringBuilder queryString = new StringBuilder("select ");
        boolean firstColumn = true;
        StringBuilder conditionString = new StringBuilder("");
        String orderBy = "";
        for (Object[] columnName : colNames) {
            if (firstColumn) {
                firstColumn = false;
                orderBy = " order by alias." + columnName[0] + " asc ";
            } else {
                queryString.append(", ");
                conditionString.append("OR ");
            }
            queryString.append("alias." + columnName[0]);
            if (!columnName[1].equals("java.lang.String")) {
                conditionString.append("(lower(str(alias." + columnName[0] + ")) like '" + columnValue.toLowerCase() + "%" + "') ");
                continue;
            }
            conditionString.append("(lower(alias." + columnName[0] + ") like '" + columnValue.toLowerCase() + "%" + "') ");
        }
        queryString.append(" from " + tableName + " as alias where ");
        queryString.append((CharSequence)conditionString);
        queryString.append(orderBy);
        return queryString.toString();
    }

    private static Object[] buildQueryWithParameters(String columnValue, String tableName, List<Object[]> colNames) {
        StringBuilder queryString = new StringBuilder("select ");
        boolean firstColumn = true;
        StringBuilder conditionString = new StringBuilder("");
        int parameterPosition = 1;
        String orderBy = "";
        ArrayList<Object> valueList = new ArrayList<Object>();
        Object[] objArr = new Object[2];
        for (Object[] columnName : colNames) {
            Date date;
            if (firstColumn) {
                firstColumn = false;
                orderBy = " order by alias." + columnName[0] + " asc ";
            } else {
                queryString.append(", ");
                if (columnName[1].equals("java.util.Date")) {
                    date = DateUtil.stringToDate((String)columnValue, (String)columnName[2].toString());
                    if (date != null) {
                        conditionString.append("OR ");
                    }
                } else {
                    conditionString.append("OR ");
                }
            }
            queryString.append("alias." + columnName[0]);
            if (columnName[1].equals("java.lang.String")) {
                conditionString.append("(lower(alias." + columnName[0] + ") like ?" + String.valueOf(parameterPosition++) + " ) ");
                valueList.add(columnValue.toLowerCase() + "%");
                continue;
            }
            if (columnName[1].equals("java.util.Date")) {
                date = DateUtil.stringToDate((String)columnValue, (String)columnName[2].toString());
                if (date == null) continue;
                conditionString.append("(alias." + columnName[0] + " between ?" + String.valueOf(parameterPosition++) + " and ?" + String.valueOf(parameterPosition++) + " ) ");
                valueList.add(DateUtil.startOfDay((Date)date));
                valueList.add(DateUtil.endOfDay((Date)date));
                continue;
            }
            if (columnName[1].equals("java.lang.Integer") || columnName[1].equals("java.lang.Long") || columnName[1].equals("java.lang.Short") || columnName[1].equals("no.g9.support.Numeric")) {
                conditionString.append("(lower(trim(str(alias." + columnName[0] + "))) like ?" + String.valueOf(parameterPosition++) + " ) ");
                valueList.add(columnValue.toLowerCase() + "%");
                continue;
            }
            conditionString.append("(lower(str(alias." + columnName[0] + ")) like ?" + String.valueOf(parameterPosition++) + " ) ");
            valueList.add(columnValue.toLowerCase() + "%");
        }
        queryString.append(" from " + tableName + " as alias where ");
        queryString.append((CharSequence)conditionString);
        queryString.append(orderBy);
        objArr[0] = queryString.toString();
        objArr[1] = valueList;
        return objArr;
    }

    public static List<Object[]> getColumnNamesAndDataTypes(String valueAttribute, List<String> columnAttributes, RoleNameHelper roleNameHelper) {
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(valueAttribute);
        if (columnAttributes.size() != 0) {
            columnNames.addAll(columnAttributes);
        } else {
            columnNames.add(valueAttribute);
        }
        Object[] colNames = null;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < columnNames.size(); ++i) {
            colNames = roleNameHelper.getColumnName(valueAttribute, ((String)columnNames.get(i)).trim());
            list.add(colNames);
        }
        return list;
    }
}

