/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import no.g9.client.core.validator.FieldValidator;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationResult;

public class DateValidator
implements FieldValidator {
    private SimpleDateFormat pattern;
    private String failMessageID = "-1523";
    private Object[] failMessageArgs = null;
    private boolean lenient = false;

    public void setDatePattern(String pattern) {
        this.pattern = new SimpleDateFormat(pattern);
        this.pattern.setLenient(this.lenient);
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
        if (this.pattern != null) {
            this.pattern.setLenient(lenient);
        }
    }

    public void setFailMessageNumber(String messageID) {
        this.failMessageID = messageID;
    }

    public void setFailMessageArgs(Object[] messageArgs) {
        this.failMessageArgs = messageArgs != null ? (Object[])messageArgs.clone() : null;
    }

    @Override
    public ValidationResult validate(Object value, ValidateContext context) {
        if (value == null) {
            return ValidationResult.DEFAULT_OK_RESULT;
        }
        try {
            this.pattern.parse(value.toString());
            return ValidationResult.DEFAULT_OK_RESULT;
        }
        catch (ParseException e) {
            return new ValidationResult(false, this.failMessageID, this.failMessageArgs);
        }
    }
}

