/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.validator;

import com.google.common.base.Objects;
import java.util.Arrays;

public class ValidationResult {
    public static final String DEFAULT_OK_MESSAGE = null;
    public static final String DEFAULT_FAIL_MESSAGE = "-1523";
    public static final ValidationResult DEFAULT_OK_RESULT = new ValidationResult(true);
    public static final ValidationResult DEFAULT_FAIL_RESULT = new ValidationResult(false, "-1523", null);
    private final boolean result;
    private final String messageID;
    private final Object[] msgArgs;

    public ValidationResult(boolean result, String msgID, Object[] msgArgs) {
        this.result = result;
        this.messageID = msgID;
        this.msgArgs = msgArgs != null ? (Object[])msgArgs.clone() : null;
    }

    public ValidationResult(boolean result) {
        this.result = result;
        this.messageID = result ? DEFAULT_OK_MESSAGE : DEFAULT_FAIL_MESSAGE;
        this.msgArgs = null;
    }

    public boolean succeeded() {
        return this.result;
    }

    @Deprecated
    public boolean getResult() {
        return this.result;
    }

    public String getMsgNumber() {
        return this.messageID;
    }

    public Object[] getMsgArgs() {
        return this.msgArgs != null ? (Object[])this.msgArgs.clone() : null;
    }

    public String toString() {
        return "ValidationResult [result=" + this.result + ", messageID=" + this.messageID + ", msgArgs=" + Arrays.toString(this.msgArgs) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        return Objects.equal((Object)this.result, (Object)other.result) && Objects.equal((Object)this.messageID, (Object)other.messageID) && Objects.equal((Object)Arrays.toString(this.msgArgs), (Object)Arrays.toString(this.msgArgs));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.result, this.messageID, Arrays.toString(this.msgArgs)});
    }
}

