/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;


import java.util.ArrayList;
import java.util.List;

import no.esito.util.BeanID;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.DialogInteraction;
import no.g9.client.core.action.HookConfigurator;
import no.g9.client.core.controller.DialogConstant;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * The hook provider is used to deliver hooks matching filters
 *
 */
@BeanID("hookProvider")
public class HookProviderImpl implements HookProvider {

    @Autowired(required=false)
    private List<HookConfigurator> hookConfigurators=new ArrayList<HookConfigurator>();

    private boolean matches(DialogConstant filter, DialogConstant actual) {
        return filter == null || filter == actual;
	}

    @Override
    public List<DialogInteraction> getCallerInteractionHook(DialogConstant caller) {
       List<DialogInteraction> theHooks = new ArrayList<DialogInteraction>();
       for (HookConfigurator hookConfigurator : getHookConfigurators()) {
          DialogConstant thisCaller = hookConfigurator.getCaller();
          if (matches(thisCaller,caller)){
              theHooks.add(hookConfigurator.getHook());
          }
       }
       return theHooks;
    }



	@Override
    public List<DialogInteraction> getCalleeInteractionHook(DialogConstant callee) {
        List<DialogInteraction> theHooks = new ArrayList<DialogInteraction>();
        for (HookConfigurator hookConfigurator : getHookConfigurators()) {
            DialogConstant thisCallee = hookConfigurator.getCallee();
            if (matches(thisCallee,callee)){
                theHooks.add(hookConfigurator.getHook());
            }
         }
         return theHooks;
    }


    /**
     * Get a HookProviderImpl instance that gives access to its internal workings
     * @return the instance
     */
    public static HookProviderImpl getInstance(){
        HookProviderImpl retVal = ServiceLoader
        .<HookProviderImpl> getService(HookProviderImpl.class);
        return retVal;
    }

    /**
     * sets the list of configurators
     * @param hookConfigurators the list of hooks
     */
    public void setHookConfigurators(List<HookConfigurator> hookConfigurators) {
        this.hookConfigurators = hookConfigurators;
    }

    /**
     * Returrsn the list of configurators
     * @return the list of
     */
    public List<HookConfigurator> getHookConfigurators() {
        return hookConfigurators;
    }
}



