/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.communication;

import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.CallBack;
import no.g9.client.core.controller.CallBackProvider;
import no.g9.client.core.controller.DialogSetupValue;

/**
 * Encapsulates a parameter provided by a message as a DialogSetupValue.
 */
public class SystemMessageDialogSetupValue implements DialogSetupValue<String>, CallBackProvider {
    private final String value;
    private SystemMessage callBackMessage;
    private ApplicationController applicationController;

    /**
     * Sets the value
     *
     * @param value the value
     * @param applicationController the application controller which handles the call back
     */
    public SystemMessageDialogSetupValue(String value, ApplicationController applicationController) {
        this.value = extractCallBack(value);
        this.applicationController = applicationController;
    }

    @Override
    public String getSetupValue() {
        return value;
    }

    @Override
    public CallBack getCallBack() {
        if (callBackMessage != null) {
            return applicationController.getExternalCallBack(callBackMessage);
        }
        return null;
    }

    private String extractCallBack(String value) {
        String retVal = value;
        SystemMessage msg = new SystemMessage(value);
        if (SystemMessage.CALLBACK_PORT.equals(msg.port)) {
            SystemMessage payload = new SystemMessage(msg.payload);
            String actionInvoker = payload.receiver;
            this.callBackMessage = SystemMessage.CALLBACK_TEMPLATE.receiver(msg.receiver).payload(actionInvoker);
            retVal = payload.payload;
        }
        return retVal;
    }
}
