/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

/**
 * Flag used to mark the intended storage-operation for an instance.  
 * <p>
 * <strong>WARNING:</strong> Although this interface is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public enum InstanceFlag {
	/**
	 * Mark this instance for deletion
	 */
	DELETE,
	/**
	 * Convenience flag, no meaning other than to avoid null-checks
	 */
	NO_FLAG
}