/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.rpc;

import java.util.ArrayList;
import java.util.List;

import no.g9.client.core.action.ActionTask;
import no.g9.client.core.action.ParameterBinding;
import no.g9.client.core.action.RemoteServiceTarget;
import no.g9.service.RemoteServiceConstant;

/**
 * Implementation of the RemoteServiceTarget interface.
 */
public class RemoteServiceImpl implements RemoteServiceTarget {

    private List<ParameterBinding<?>> parameterBindings = new ArrayList<ParameterBinding<?>>();
    private ParameterBinding<?> returnParameter;
    private final RemoteServiceConstant service;
    private ActionTask<?> actionTask;

    /**
     * Constructs a new RemoteServiceTarget
     *
     * @param service the target service
     */
    public RemoteServiceImpl(RemoteServiceConstant service) {
        this.service = service;
    }

    @Override
    public List<ParameterBinding<?>> getParameterBindings() {
        return parameterBindings;
    }

    /**
     * Adds the parameter binding to this remote service invocation.
     * @param binding the parameter binding to add.
     */
    public void addParameterBinding(ParameterBinding<?> binding) {
        if (binding.isReturnValue()) {
            returnParameter = binding;
        } else {
            parameterBindings.add(binding);
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public <A> ParameterBinding<A> getReturnParameter() {
        return (ParameterBinding<A>) returnParameter;
    }

    @Override
    public ActionTask<?> getActionTask() {
        return actionTask;
    }

    /**
     * Set the action task that will invoke the remote service method.
     * @param actionTask the invoking action task.
     */
    public void setActionTask(ActionTask<?> actionTask) {
        this.actionTask = actionTask;
    }

    @Override
    public String toString() {
        return "RemoteServiceImpl ["
                + (service != null ? "targetName=" + service : "") + "]";
    }

    @Override
    public RemoteServiceConstant getService() {
        return service;
    }


}
