/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.util;

import java.util.HashMap;
import java.util.Map;

import no.g9.client.core.view.Resource;
import no.g9.client.core.view.ResourceStore;

/**
 * Resource Store is used to keep resources that the controller want the view to
 * grab (and possibly display)
 */
public final class ResourceStoreImpl implements ResourceStore {

    private final Map<String, Resource> resourceMap =
            new HashMap<String, Resource>();

    /*
     * (non-Javadoc)
     * 
     * @see
     * no.g9.client.core.view.ResourceStore#putResource(no.g9.client
     * .core.view.Resource)
     */
    @Override
    public synchronized void putResource(Resource resource) {
        resourceMap.put(resource.getId(), resource);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * no.g9.client.core.view.ResourceStore#getResource(java.lang.String)
     */
    @Override
    public synchronized Resource getResource(String id) {
        return resourceMap.get(id);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * no.g9.client.core.view.ResourceStore#removeResource(java.lang.String)
     */
    @Override
    public synchronized Resource removeResource(String id) {
        return resourceMap.remove(id);
    }
}
