/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.ViewConstant;

/**
 * Utility class for dealing with view constants.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class ViewConstantHelper {

    /**
     * Get all children of the specified dialog object.
     *
     * @param parent the dialog object
     * @return a collection of all children
     */
    public static Collection<DialogObjectConstant> getChildren(ViewConstant parent) {
        Collection<ViewConstant> allComps = parent.getAll();
        Collection<DialogObjectConstant> children = new ArrayList<DialogObjectConstant>();
        for (ViewConstant comp : allComps) {
            if (parent.equals(comp.getParent())) {
                if (comp instanceof DialogObjectConstant) {
                    DialogObjectConstant doc = (DialogObjectConstant) comp;
                    children.add(doc);
                }
            }
        }
        return children;
    }

    /**
     * Get all descendants of the specified dialog object.
     *
     * @param parent the dialog object
     * @return a list of all descendants
     */
    public static List<DialogObjectConstant> getDescendants(DialogObjectConstant parent) {
        List<DialogObjectConstant> descendants = new ArrayList<DialogObjectConstant>();
        for (ViewConstant comp : parent.getAll()) {
            if (comp instanceof DialogObjectConstant) {
                DialogObjectConstant doc = (DialogObjectConstant) comp;
                if (isAncestor(doc, parent)) {
                    descendants.add(doc);
                }
            }
        }
        return descendants;
    }

    /**
     * Check if the given view constant is a descendant of the given ancestor.
     *
     * @param descendant the view constant to check
     * @param ancestor the possible ancestor of descendant
     * @return true if descendant and ancestor are related
     */
    public static boolean isAncestor(ViewConstant descendant, ViewConstant ancestor) {
        if (descendant == null || descendant.getParent() == null) {
            return false;
        }
        if (descendant.getParent().equals(ancestor)) {
            return true;
        }
        return isAncestor(descendant.getParent(), ancestor);
    }

}
