/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.validation;

import no.esito.util.ServiceLoader;
import no.g9.client.core.controller.DialogController;
import no.g9.support.ActionType;

/**
 * Used to crea<te validation manager factory instances.
 *
 */
public class ValidationManagerFactory {
	
    /**
     * Create a new validation manager
     * @param action actual action used by manager to set validate context
     * @param dCtrl dialog controller used by manager to set validate context
     * @return a new validation manager, ready for use
     */
	public static ValidationManager create(ActionType action, DialogController dCtrl) {
		ValidationManager manager = ServiceLoader.getService(ValidationManager.class);
		return manager.initManager(action, dCtrl);
	}
	

}
