/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import no.g9.client.core.controller.DialogController;

/**
 * ActionParameterHook is used to setup actions targets with initial values and
 * get the action return value.
 *
 * @param <T>
 *            type of setup value
 * @param <U>
 *            type of return value
 * @param <V>
 *            type of action target
 */
public interface ActionParameterHook<T, U, V> {

    /**
     * Get the setup value that will be used to setup the action target.
     * <p>
     * <b>Note:</b> The <code>providedSetupValue</code> parameter might be
     * <code>null</code>.
     *
     * @param providedSetupValue
     *            the setup value
     * @param actionInvoker
     *            the dialog that invokes the action
     * @param actionTarget
     *            the action target
     * @return the setup value for the action
     */
    public T getSetupValue(T providedSetupValue,
            DialogController actionInvoker, V actionTarget);

    /**
     * Get the return value from the action.
     * <p>
     * <b>Note:</b> The <code>providedReturnValue</code> parameter might be
     * <code>null</code>.
     *
     * @param providedReturnValue
     *            the return value
     *
     * @param actionInvoker
     *            the dialog that invoked the action
     * @param actionTarget
     *            the action target
     * @return the action return value
     */
    public U getActionReturnValue(U providedReturnValue,
            DialogController actionInvoker, V actionTarget);
}
