/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

/**
 * The task that is performed by an action
 * @param <V> the result type of the action.
 *  */
public abstract class ActionTask<V> implements Callable<V> {

    /**
     * The task object, used to transfer data between actions
     */
    private Object taskObject;

    /**
     * @return the taskObject
     */
    public synchronized Object getTaskObject() {
        return taskObject;
    }

    /**
     * @param taskObject the taskObject to set
     */
    public synchronized void setTaskObject(Object taskObject) {
        this.taskObject = taskObject;
    }

    /** General purpose flag. Initial false */
    public boolean FLAG;

    @Override
    public String toString() {
        return "ActionTask [taskObject=" + taskObject + ", FLAG=" + FLAG + "]";
    }


}
