/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

/**
 * @param <T> The result type
 */
public abstract class CheckableHookAdapter<T> extends ActionHookAdapter<T> implements Checkable {

    /**
     * {@inheritDoc}
     * This default implementation simply returns the checkResult.
     */
    @Override
    @ThreadInfo(ThreadType.WORKER)
	public Boolean checked(Boolean checkResult) {
	    return checkResult;
	}
}

